//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace LinkedList
{
	/// <summary>
	/// Podsumowanie dla ObjectAllocation.
	/// </summary>
	public class ObjectAllocation : System.Windows.Forms.Form
	{
		private LinkedObject head;
		private FinalizedLinkedObject fhead;
		private DisposeLinkedObject dhead;
		private System.Windows.Forms.Button allocateButton;
		private System.Windows.Forms.Button deallocateButton;
		private System.Windows.Forms.Button collectButton;
		private System.Windows.Forms.Button deallocateFButton;
		private System.Windows.Forms.Button allocateFButton;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox gen0Count;
		private System.Windows.Forms.TextBox gen1Count;
		private System.Windows.Forms.TextBox gen2Count;
		private System.Windows.Forms.TextBox fgen2Count;
		private System.Windows.Forms.TextBox fgen1Count;
		private System.Windows.Forms.TextBox fgen0Count;
		private System.Windows.Forms.TextBox finalizerCount;
		private System.Windows.Forms.Button deallocateDButton;
		private System.Windows.Forms.Button allocateDButton;
		private System.Windows.Forms.TextBox dgen2Count;
		private System.Windows.Forms.TextBox dgen1Count;
		private System.Windows.Forms.TextBox dgen0Count;
		private System.Windows.Forms.TextBox allocationTime;
		private System.Windows.Forms.TextBox fallocationTime;
		private System.Windows.Forms.TextBox dallocationTime;
		private System.Windows.Forms.TextBox collectTime;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox totalMemory;
		private System.Windows.Forms.TextBox prevTotalMemory;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ObjectAllocation()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.allocateButton = new System.Windows.Forms.Button();
			this.deallocateButton = new System.Windows.Forms.Button();
			this.collectButton = new System.Windows.Forms.Button();
			this.deallocateFButton = new System.Windows.Forms.Button();
			this.allocateFButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.gen0Count = new System.Windows.Forms.TextBox();
			this.gen1Count = new System.Windows.Forms.TextBox();
			this.gen2Count = new System.Windows.Forms.TextBox();
			this.fgen2Count = new System.Windows.Forms.TextBox();
			this.fgen1Count = new System.Windows.Forms.TextBox();
			this.fgen0Count = new System.Windows.Forms.TextBox();
			this.finalizerCount = new System.Windows.Forms.TextBox();
			this.deallocateDButton = new System.Windows.Forms.Button();
			this.allocateDButton = new System.Windows.Forms.Button();
			this.dgen2Count = new System.Windows.Forms.TextBox();
			this.dgen1Count = new System.Windows.Forms.TextBox();
			this.dgen0Count = new System.Windows.Forms.TextBox();
			this.allocationTime = new System.Windows.Forms.TextBox();
			this.fallocationTime = new System.Windows.Forms.TextBox();
			this.dallocationTime = new System.Windows.Forms.TextBox();
			this.collectTime = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.totalMemory = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.prevTotalMemory = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// allocateButton
			// 
			this.allocateButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.allocateButton.Location = new System.Drawing.Point(9, 19);
			this.allocateButton.Name = "allocateButton";
			this.allocateButton.Size = new System.Drawing.Size(263, 26);
			this.allocateButton.TabIndex = 0;
			this.allocateButton.Text = "Alokacja obiektw";
			this.allocateButton.Click += new System.EventHandler(this.OnAllocateObjects);
			// 
			// deallocateButton
			// 
			this.deallocateButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.deallocateButton.Location = new System.Drawing.Point(9, 48);
			this.deallocateButton.Name = "deallocateButton";
			this.deallocateButton.Size = new System.Drawing.Size(263, 27);
			this.deallocateButton.TabIndex = 1;
			this.deallocateButton.Text = "Dealokacja obiektw";
			this.deallocateButton.Click += new System.EventHandler(this.OnDeallocateObjects);
			// 
			// collectButton
			// 
			this.collectButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.collectButton.Location = new System.Drawing.Point(96, 232);
			this.collectButton.Name = "collectButton";
			this.collectButton.Size = new System.Drawing.Size(103, 27);
			this.collectButton.TabIndex = 2;
			this.collectButton.Text = "Oczyszczanie";
			this.collectButton.Click += new System.EventHandler(this.OnCollect);
			// 
			// deallocateFButton
			// 
			this.deallocateFButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.deallocateFButton.Location = new System.Drawing.Point(9, 120);
			this.deallocateFButton.Name = "deallocateFButton";
			this.deallocateFButton.Size = new System.Drawing.Size(263, 27);
			this.deallocateFButton.TabIndex = 4;
			this.deallocateFButton.Text = "Dealokacja obiektw F";
			this.deallocateFButton.Click += new System.EventHandler(this.OnDeallocateFObjects);
			// 
			// allocateFButton
			// 
			this.allocateFButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.allocateFButton.Location = new System.Drawing.Point(9, 88);
			this.allocateFButton.Name = "allocateFButton";
			this.allocateFButton.Size = new System.Drawing.Size(263, 27);
			this.allocateFButton.TabIndex = 3;
			this.allocateFButton.Text = "Alokacja obiektw F";
			this.allocateFButton.Click += new System.EventHandler(this.OnAllocateFObjects);
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(8, 320);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(83, 20);
			this.label1.TabIndex = 5;
			this.label1.Text = "Gen 0";
			// 
			// label2
			// 
			this.label2.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(8, 360);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(83, 20);
			this.label2.TabIndex = 6;
			this.label2.Text = "Gen 1";
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label3.Location = new System.Drawing.Point(8, 400);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(83, 21);
			this.label3.TabIndex = 7;
			this.label3.Text = "Gen 2";
			// 
			// gen0Count
			// 
			this.gen0Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.gen0Count.Location = new System.Drawing.Point(96, 312);
			this.gen0Count.Name = "gen0Count";
			this.gen0Count.ReadOnly = true;
			this.gen0Count.Size = new System.Drawing.Size(83, 30);
			this.gen0Count.TabIndex = 8;
			this.gen0Count.Text = "";
			// 
			// gen1Count
			// 
			this.gen1Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.gen1Count.Location = new System.Drawing.Point(96, 352);
			this.gen1Count.Name = "gen1Count";
			this.gen1Count.ReadOnly = true;
			this.gen1Count.Size = new System.Drawing.Size(83, 30);
			this.gen1Count.TabIndex = 9;
			this.gen1Count.Text = "";
			// 
			// gen2Count
			// 
			this.gen2Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.gen2Count.Location = new System.Drawing.Point(96, 392);
			this.gen2Count.Name = "gen2Count";
			this.gen2Count.ReadOnly = true;
			this.gen2Count.Size = new System.Drawing.Size(83, 30);
			this.gen2Count.TabIndex = 10;
			this.gen2Count.Text = "";
			// 
			// fgen2Count
			// 
			this.fgen2Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fgen2Count.Location = new System.Drawing.Point(200, 392);
			this.fgen2Count.Name = "fgen2Count";
			this.fgen2Count.ReadOnly = true;
			this.fgen2Count.Size = new System.Drawing.Size(83, 30);
			this.fgen2Count.TabIndex = 13;
			this.fgen2Count.Text = "";
			// 
			// fgen1Count
			// 
			this.fgen1Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fgen1Count.Location = new System.Drawing.Point(200, 352);
			this.fgen1Count.Name = "fgen1Count";
			this.fgen1Count.ReadOnly = true;
			this.fgen1Count.Size = new System.Drawing.Size(83, 30);
			this.fgen1Count.TabIndex = 12;
			this.fgen1Count.Text = "";
			// 
			// fgen0Count
			// 
			this.fgen0Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fgen0Count.Location = new System.Drawing.Point(200, 312);
			this.fgen0Count.Name = "fgen0Count";
			this.fgen0Count.ReadOnly = true;
			this.fgen0Count.Size = new System.Drawing.Size(83, 30);
			this.fgen0Count.TabIndex = 11;
			this.fgen0Count.Text = "";
			// 
			// finalizerCount
			// 
			this.finalizerCount.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.finalizerCount.Location = new System.Drawing.Point(200, 432);
			this.finalizerCount.Name = "finalizerCount";
			this.finalizerCount.ReadOnly = true;
			this.finalizerCount.Size = new System.Drawing.Size(83, 30);
			this.finalizerCount.TabIndex = 14;
			this.finalizerCount.Text = "";
			// 
			// deallocateDButton
			// 
			this.deallocateDButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.deallocateDButton.Location = new System.Drawing.Point(8, 192);
			this.deallocateDButton.Name = "deallocateDButton";
			this.deallocateDButton.Size = new System.Drawing.Size(263, 27);
			this.deallocateDButton.TabIndex = 16;
			this.deallocateDButton.Text = "Dealokacja obiektw D";
			this.deallocateDButton.Click += new System.EventHandler(this.OnDeallocateDObjects);
			// 
			// allocateDButton
			// 
			this.allocateDButton.Font = new System.Drawing.Font("Verdana", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.allocateDButton.Location = new System.Drawing.Point(8, 160);
			this.allocateDButton.Name = "allocateDButton";
			this.allocateDButton.Size = new System.Drawing.Size(263, 27);
			this.allocateDButton.TabIndex = 15;
			this.allocateDButton.Text = "Alokacja obiektw D";
			this.allocateDButton.Click += new System.EventHandler(this.OnAllocateDObjects);
			// 
			// dgen2Count
			// 
			this.dgen2Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgen2Count.Location = new System.Drawing.Point(304, 392);
			this.dgen2Count.Name = "dgen2Count";
			this.dgen2Count.ReadOnly = true;
			this.dgen2Count.Size = new System.Drawing.Size(83, 30);
			this.dgen2Count.TabIndex = 19;
			this.dgen2Count.Text = "";
			// 
			// dgen1Count
			// 
			this.dgen1Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgen1Count.Location = new System.Drawing.Point(304, 352);
			this.dgen1Count.Name = "dgen1Count";
			this.dgen1Count.ReadOnly = true;
			this.dgen1Count.Size = new System.Drawing.Size(83, 30);
			this.dgen1Count.TabIndex = 18;
			this.dgen1Count.Text = "";
			// 
			// dgen0Count
			// 
			this.dgen0Count.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgen0Count.Location = new System.Drawing.Point(304, 312);
			this.dgen0Count.Name = "dgen0Count";
			this.dgen0Count.ReadOnly = true;
			this.dgen0Count.Size = new System.Drawing.Size(83, 30);
			this.dgen0Count.TabIndex = 17;
			this.dgen0Count.Text = "";
			// 
			// allocationTime
			// 
			this.allocationTime.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.allocationTime.Location = new System.Drawing.Point(280, 16);
			this.allocationTime.Name = "allocationTime";
			this.allocationTime.ReadOnly = true;
			this.allocationTime.Size = new System.Drawing.Size(104, 30);
			this.allocationTime.TabIndex = 20;
			this.allocationTime.Text = "";
			this.allocationTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// fallocationTime
			// 
			this.fallocationTime.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.fallocationTime.Location = new System.Drawing.Point(280, 88);
			this.fallocationTime.Name = "fallocationTime";
			this.fallocationTime.ReadOnly = true;
			this.fallocationTime.Size = new System.Drawing.Size(104, 30);
			this.fallocationTime.TabIndex = 21;
			this.fallocationTime.Text = "";
			this.fallocationTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// dallocationTime
			// 
			this.dallocationTime.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dallocationTime.Location = new System.Drawing.Point(280, 160);
			this.dallocationTime.Name = "dallocationTime";
			this.dallocationTime.ReadOnly = true;
			this.dallocationTime.Size = new System.Drawing.Size(104, 30);
			this.dallocationTime.TabIndex = 22;
			this.dallocationTime.Text = "";
			this.dallocationTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// collectTime
			// 
			this.collectTime.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.collectTime.Location = new System.Drawing.Point(280, 224);
			this.collectTime.Name = "collectTime";
			this.collectTime.ReadOnly = true;
			this.collectTime.Size = new System.Drawing.Size(104, 30);
			this.collectTime.TabIndex = 23;
			this.collectTime.Text = "";
			this.collectTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label4
			// 
			this.label4.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(0, 280);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(144, 20);
			this.label4.TabIndex = 24;
			this.label4.Text = "Cakowita pami";
			// 
			// totalMemory
			// 
			this.totalMemory.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.totalMemory.Location = new System.Drawing.Point(272, 272);
			this.totalMemory.Name = "totalMemory";
			this.totalMemory.ReadOnly = true;
			this.totalMemory.Size = new System.Drawing.Size(112, 30);
			this.totalMemory.TabIndex = 25;
			this.totalMemory.Text = "";
			this.totalMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label5
			// 
			this.label5.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label5.Location = new System.Drawing.Point(392, 24);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(40, 20);
			this.label5.TabIndex = 26;
			this.label5.Text = "ms";
			// 
			// label6
			// 
			this.label6.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label6.Location = new System.Drawing.Point(392, 96);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(40, 20);
			this.label6.TabIndex = 27;
			this.label6.Text = "ms";
			// 
			// label7
			// 
			this.label7.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label7.Location = new System.Drawing.Point(392, 168);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(40, 20);
			this.label7.TabIndex = 28;
			this.label7.Text = "ms";
			// 
			// label8
			// 
			this.label8.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label8.Location = new System.Drawing.Point(392, 232);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(40, 20);
			this.label8.TabIndex = 29;
			this.label8.Text = "ms";
			// 
			// label9
			// 
			this.label9.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label9.Location = new System.Drawing.Point(392, 280);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(64, 20);
			this.label9.TabIndex = 30;
			this.label9.Text = "bajtw";
			// 
			// prevTotalMemory
			// 
			this.prevTotalMemory.Font = new System.Drawing.Font("Verdana", 13.8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.prevTotalMemory.Location = new System.Drawing.Point(152, 272);
			this.prevTotalMemory.Name = "prevTotalMemory";
			this.prevTotalMemory.ReadOnly = true;
			this.prevTotalMemory.Size = new System.Drawing.Size(112, 30);
			this.prevTotalMemory.TabIndex = 31;
			this.prevTotalMemory.Text = "";
			this.prevTotalMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// ObjectAllocation
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.ClientSize = new System.Drawing.Size(464, 478);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.prevTotalMemory,
																		  this.label9,
																		  this.label8,
																		  this.label7,
																		  this.label6,
																		  this.label5,
																		  this.totalMemory,
																		  this.label4,
																		  this.collectTime,
																		  this.dallocationTime,
																		  this.fallocationTime,
																		  this.allocationTime,
																		  this.dgen2Count,
																		  this.dgen1Count,
																		  this.dgen0Count,
																		  this.deallocateDButton,
																		  this.allocateDButton,
																		  this.finalizerCount,
																		  this.fgen2Count,
																		  this.fgen1Count,
																		  this.fgen0Count,
																		  this.gen2Count,
																		  this.gen1Count,
																		  this.gen0Count,
																		  this.label3,
																		  this.label2,
																		  this.label1,
																		  this.deallocateFButton,
																		  this.allocateFButton,
																		  this.collectButton,
																		  this.deallocateButton,
																		  this.allocateButton});
			this.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "ObjectAllocation";
			this.Text = "Alokacja obiektw powizanej listy";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ObjectAllocation());
		}

		private void OnAllocateObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			if(head == null)
			{
				head = new LinkedObject();
			}
			LinkedObject node;
			DateTime start = DateTime.Now;
			for(int i = 0; i < 100000; i++)
			{
				node = new LinkedObject(head);
				head = node;
			}
			DateTime stop = DateTime.Now;
			TimeSpan elapsed = stop - start;
			allocationTime.Text = elapsed.TotalMilliseconds.ToString();
			int [] gcount = new int [GC.MaxGeneration + 1];
			node = head;
			while(node != null)
			{
				gcount[GC.GetGeneration(node)]++;
				node = node.Link;
			}
			gen0Count.Text = Convert.ToString(gcount[0]);
			gen1Count.Text = Convert.ToString(gcount[1]);
			gen2Count.Text = Convert.ToString(gcount[2]);
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}
		private void OnDeallocateObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			head = null;
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}
		private void OnAllocateFObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			if(fhead == null)
			{
				fhead = new FinalizedLinkedObject();
			}
			FinalizedLinkedObject node;
			DateTime start = DateTime.Now;
			for(int i = 0; i < 100000; i++)
			{
				node = new FinalizedLinkedObject(fhead);
				fhead = node;
			}
			DateTime stop = DateTime.Now;
			TimeSpan elapsed = stop - start;
			fallocationTime.Text = elapsed.TotalMilliseconds.ToString();
			int [] gcount = new int [GC.MaxGeneration + 1];
			node = fhead;
			while(node != null)
			{
				gcount[GC.GetGeneration(node)]++;
				node = node.Link;
			}
			fgen0Count.Text = Convert.ToString(gcount[0]);
			fgen1Count.Text = Convert.ToString(gcount[1]);
			fgen2Count.Text = Convert.ToString(gcount[2]);
			// finalizerCount.Text = Convert.ToString(FinalizedLinkedObject.Count);
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}
		private void OnDeallocateFObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			fhead = null;
			// finalizerCount.Text = Convert.ToString(FinalizedLinkedObject.Count);
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}
		private void OnCollect(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			DateTime start = DateTime.Now;
			GC.Collect();
			DateTime stop = DateTime.Now;
			TimeSpan elapsed = stop - start;
			collectTime.Text = elapsed.TotalMilliseconds.ToString();
			int [] gcount = new int [GC.MaxGeneration + 1];
			LinkedObject node = head;
			while(node != null)
			{
				gcount[GC.GetGeneration(node)]++;
				node = node.Link;
			}
			gen0Count.Text = Convert.ToString(gcount[0]);
			gen1Count.Text = Convert.ToString(gcount[1]);
			gen2Count.Text = Convert.ToString(gcount[2]);

			for(int i = 0; i < gcount.Length; i++)
				gcount[i] = 0;

			FinalizedLinkedObject fnode = fhead;
			while(fnode != null)
			{
				gcount[GC.GetGeneration(fnode)]++;
				fnode = fnode.Link;
			}
			fgen0Count.Text = Convert.ToString(gcount[0]);
			fgen1Count.Text = Convert.ToString(gcount[1]);
			fgen2Count.Text = Convert.ToString(gcount[2]);
			// finalizerCount.Text = Convert.ToString(FinalizedLinkedObject.Count);

			for(int i = 0; i < gcount.Length; i++)
				gcount[i] = 0;

			DisposeLinkedObject dnode = dhead;
			while(dnode != null)
			{
				gcount[GC.GetGeneration(dnode)]++;
				dnode = dnode.Link;
			}
			dgen0Count.Text = Convert.ToString(gcount[0]);
			dgen1Count.Text = Convert.ToString(gcount[1]);
			dgen2Count.Text = Convert.ToString(gcount[2]);
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}

		private void OnAllocateDObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			if(dhead == null)
			{
				dhead = new DisposeLinkedObject();
			}
			DisposeLinkedObject node;
			DateTime start = DateTime.Now;
			for(int i = 0; i < 100000; i++)
			{
				node = new DisposeLinkedObject(dhead);
				dhead = node;
			}
			DateTime stop = DateTime.Now;
			TimeSpan elapsed = stop - start;
			dallocationTime.Text = elapsed.TotalMilliseconds.ToString();
			int [] gcount = new int [GC.MaxGeneration + 1];
			node = dhead;
			while(node != null)
			{
				gcount[GC.GetGeneration(node)]++;
				node = node.Link;
			}
			dgen0Count.Text = Convert.ToString(gcount[0]);
			dgen1Count.Text = Convert.ToString(gcount[1]);
			dgen2Count.Text = Convert.ToString(gcount[2]);
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}

		private void OnDeallocateDObjects(object sender, System.EventArgs e)
		{
			prevTotalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
			DisposeLinkedObject node = dhead;
			DisposeLinkedObject temp;
			while(node != null)
			{
				temp = node.Link;
				node.Close();
				node = temp;
			}
			dhead = null;
			totalMemory.Text = Convert.ToString(GC.GetTotalMemory(false));
		}
	}
}
